load('flagellum.mat')

ind_pt=[1:20:200 200];

Npt=length(ind_pt);
Nphases=10;

ns=300;

splines=cell(1,Nphases);
L=zeros(1,Nphases);

%% reparametrization by arc length

for ph=1:Nphases
splines{1,ph}=spaps(linspace(0,1,Npt),[ splnoptptI(ph,ind_pt) ; splnoptptJ(ph,ind_pt) ; splnoptptK(ph,ind_pt) ],0.8,3);
tan_norm=@(xi) sqrt(sum(fnval(xi,fnder(splines{1,ph},1)).^2 ,1));
L(ph) = integral(tan_norm,0,1);
end

Xs=zeros(Nphases,ns+1);
xs=zeros(1,ns+1);
hs=zeros(1,Nphases);

for ph=1:Nphases
    hs(ph)=L(ph)/ns; 
for ind=2:(ns+1)
xs(ind)=xs(ind-1) + hs(ph)/norm(fnval(fnder(splines{1,ph},1),xs(ind-1)));
end
Xs(ph,:)=xs/xs(ns+1);
end

%% torsion measurament

r1=zeros(Nphases,ns+1);
r2=zeros(Nphases,ns+1);
r3=zeros(Nphases,ns+1);

T1=zeros(Nphases,ns+1);
T2=zeros(Nphases,ns+1);
T3=zeros(Nphases,ns+1);

Ts1=zeros(Nphases,ns+1);
Ts2=zeros(Nphases,ns+1);
Ts3=zeros(Nphases,ns+1);

B1=zeros(Nphases,ns+1);
B2=zeros(Nphases,ns+1);
B3=zeros(Nphases,ns+1);

Bs1=zeros(Nphases,ns+1);
Bs2=zeros(Nphases,ns+1);
Bs3=zeros(Nphases,ns+1);

TAU=zeros(Nphases,ns+1);
TAU_norm=zeros(Nphases,ns+1);

K=zeros(Nphases,ns+1);


for ph=1:Nphases
flag_pts=fnval(Xs(ph,:),splines{1,ph});
r1(ph,:)=flag_pts(1,:);
r2(ph,:)=flag_pts(2,:);
r3(ph,:)=flag_pts(3,:);
spline_tan=fnval(Xs(ph,:),fnder(splines{1,ph},1) );
spline_unit=spline_tan./sqrt(sum(fnval(Xs(ph,:),fnder(splines{1,ph},1)).^2 ,1));
T1(ph,:)=spline_unit(1,:);
T2(ph,:)=spline_unit(2,:);
T3(ph,:)=spline_unit(3,:);
end


 D1= diag(-0.5*ones(ns,1),-1) +   ...
     diag(0.5*ones(ns,1),1) + ...
     [[-3/2 , -0.5+4/2 ,  -1/2  ,  zeros(1,ns-2) ]; ...
      zeros(ns-1,ns+1) ; ...
     [zeros(1,ns-2), 1/2, 0.5-4/2 , 3/2]];

for ph=1:Nphases
    
    Ts1(ph,:)=(1/hs(ph))*D1*T1(ph,:)' ;
     Ts2(ph,:)= (1/hs(ph))*D1*T2(ph,:)' ;
      Ts3(ph,:)= (1/hs(ph))*D1*T3(ph,:)' ;
 
 K(ph,:)=vecnorm([ Ts1(ph,:) ; Ts2(ph,:) ; Ts3(ph,:)] );
 
 B1(ph,:)=(T2(ph,:).*Ts3(ph,:)-T3(ph,:).*Ts2(ph,:))./K(ph,:);
 B2(ph,:)=(T3(ph,:).*Ts1(ph,:)-T1(ph,:).*Ts3(ph,:))./K(ph,:);
 B3(ph,:)=(T1(ph,:).*Ts2(ph,:)-T2(ph,:).*Ts1(ph,:))./K(ph,:);
 
 
   Bs1(ph,:)=(1/hs(ph))*D1*B1(ph,:)' ;
     Bs2(ph,:)= (1/hs(ph))*D1*B2(ph,:)' ;
      Bs3(ph,:)= (1/hs(ph))*D1*B3(ph,:)' ;
      
     TAU(ph,:)= -(Bs1(ph,:).*Ts1(ph,:) + Bs2(ph,:).*Ts2(ph,:) + Bs3(ph,:).*Ts3(ph,:) )./K(ph,:);  
     TAU_norm(ph,:)=TAU(ph,:)/(L(ph)^(-1));
end

%% plots

rhoM=50.28/2;
rhom=8.69/2;

[ xbody , ybody ,  zbody] = ellipsoid(0,0,0,rhom,rhom,rhoM);


figure
surf( xbody , ybody ,  zbody , 'FaceColor',[ 0.1 0.9 0.1],'EdgeColor',[ 0.5 0.5 0.5])
hold on
tubeplot([ splnoptptI(1,:) ; splnoptptJ(1,:) ;splnoptptK(1,:)],0.15);
tubeplot([ splnoptptI(2,:) ; splnoptptJ(2,:) ;splnoptptK(2,:)],0.15);
tubeplot([ splnoptptI(3,:) ; splnoptptJ(3,:) ;splnoptptK(3,:)],0.15);
tubeplot([ splnoptptI(4,:) ; splnoptptJ(4,:) ;splnoptptK(4,:)],0.15);
tubeplot([ splnoptptI(5,:) ; splnoptptJ(5,:) ;splnoptptK(5,:)],0.15);
tubeplot([ splnoptptI(6,:) ; splnoptptJ(6,:) ;splnoptptK(6,:)],0.15);
tubeplot([ splnoptptI(7,:) ; splnoptptJ(7,:) ;splnoptptK(7,:)],0.15);
tubeplot([ splnoptptI(8,:) ; splnoptptJ(8,:) ;splnoptptK(8,:)],0.15);
tubeplot([ splnoptptI(9,:) ; splnoptptJ(9,:) ;splnoptptK(9,:)],0.15);
tubeplot([ splnoptptI(10,:) ; splnoptptJ(10,:) ;splnoptptK(10,:)],0.15);
hold off
grid on
daspect([1 1 1])
xlim([-12 12])
ylim([-12 12])
zlim([10, rhoM + 5])
view([ 150 , 10 ])
camlight(30,30)

x = [1 Nphases];
y = [0       1];

figure
 imagesc(x,y,TAU_norm')
 colorbar
 title('\tau / L^{-1}')
 xlabel('phases')
 ylabel('s/L')
set(gca,'YDir','normal')

